{
prog: Create 'factory' settings for Blaffer NT
code: d-fader
date: August 17, 1999
cmnt:

File build is as follows:

byte 00..15: Init bytes (Blaf NT Settings)

byte 16: Foreground color 1, High nibble : Red itensity.
                             Low Nibble  : Blue (crystal??) itensity.

byte 17: Foreground color 1, High Nibble : Empty.
                             Low Nibble  : Green itensity.

byte 18: Background color 1, see byte 1.
byte 19: Background color 1, see byte 2.

byte 20: Foreground color 2, see byte 1.
byte 21: Foreground color 2, see byte 2.

byte 22: Background color 2, see byte 1.
byte 23: Background color 2, see byte 2.

byte 24: interrupt frequency, 0 if 50Hz, 1 if 60Hz.
byte 25: settings scan, 0 if OFF, 1 if ON.
byte 26: note audition, 1 if OFF, 0 if ON.
byte 27: equalizer type, 0 if normal, 1 if volume.
byte 28: cursor mode, 1 if normal, 0 if switched.
byte 29: edit mode, 0 if type, 1 if 1Key
byte 30: octaves: 0 -   1
                  1 - 1-2
                  2 - 2-3
                  3 - 3-4
                  4 - 4-5
                  5 - 5-6
                  6 - 6-7
                  7 - 7-8
                  8 - 8
}

const
  SetupHeader : string[16] = 'Blaf NT Settings';

  Setup       : array [1..15] of byte = ($77, $07, $00, $00,
                                         $70, $07, $30, $03,
                                         1, 1, 0, 1, 1, 0, 4);

var
  f1: file;

BEGIN
  assign (f1, 'blaf_nt.004');
  rewrite (f1, 1);

  BlockWrite (f1, SetupHeader[1], 16);
  BlockWrite (f1, Setup, SizeOf(Setup));

  close (f1);
END.
